/**
* \file: DummyMediaBrowserSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: K. Kuroda / ADIT/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_DUMMYMEDIABROWSERSOURCE__H
#define AAUTO_DUMMYMEDIABROWSERSOURCE__H


#include <string>
#include <aauto/AditMediaBrowser.h>

namespace adit { namespace aauto {

class DummyMediaBrowserImpl;

class DummyMediaBrowserSource : public AditMediaBrowser
{
public:
    DummyMediaBrowserSource(uint8_t inSessionId, MessageRouter* inMessageRouter);

    ~DummyMediaBrowserSource();

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    void setConfigItem(std::string inKey, std::string inValue);

    /**
     * @brief Register callbacks to receive media playback status notifications.
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditMediaBrowserCallbacks* inCallbacks);

    /**
     * @brief Initialize the endpoints.
     *      All configuration items must be set before calling this function.
     * @return true if initialization succeeds.
     *      false if fails. */
    bool init();

    /**
     * @brief  Shut down the endpoint and release allocated resources */
    void shutdown();

private:
    DummyMediaBrowserImpl* impl;
};

class DummyMediaBrowserImpl : public IMediaBrowserCallbacks 
{
public:
    DummyMediaBrowserImpl(MediaBrowserEndpoint* inEndpoint,
            void* inSessionContext);

    ~DummyMediaBrowserImpl();

    // implementation of DummyMediaBrowser methods
    void setConfigItem(std::string inKey, std::string inValue);
    void registerCallbacks(IAditMediaBrowserCallbacks* inCallbacks);
    bool init();
    void shutdown();

protected:
    // inherit IMediaBrowserCallbacks
    void rootNodeCallback(const struct MediaRootNodeStruct &node);
    void sourceNodeCallback(const struct MediaSourceNodeStruct &node);
    void listNodeCallback(const struct MediaListNodeStruct &node);
    void songNodeCallback (const struct MediaSongNodeStruct &node);

private:
    void* mSessionContext;
    MediaBrowserEndpoint* mEndpoint;
    IAditMediaBrowserCallbacks* mCallbacks;


//DEBUG consider later   int mediaGetNode(const string& path, uint32_t start, bool get_album_art);
//DEBUG consider later   int reportAction(const string& path, uint32_t action);
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_DUMMYMEDIABROWSERSOURCE_H */
